// SC300Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC300.h"
#include "SC300Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC300_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC300] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

BOOL on_process_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CSC300Dlg * pMainDialog = (CSC300Dlg *)(pUserData);

	CVRSDK_UPDATE_VIDEO_BUFFER( pMainDialog->m_pCustomChannelWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), 640, 480, TRUE /*ENABLE DEINTERLACING*/ );

//	CVRSDK_UPDATE_VIDEO_BUFFER( pMainDialog->m_pCustomChannelWindow, pBuffer, MAKEFOURCC('Y', 'V', '1', '2'), 640, 480, TRUE /*ENABLE DEINTERLACING*/ );

	return FALSE;
}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CSC300Dlg * pMainDialog = (CSC300Dlg *)(pUserData);

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg dialog

CSC300Dlg::CSC300Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC300Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC300Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC300Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC300Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC300Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC300Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg message handlers

BOOL CSC300Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// [2010.12.12] [HUENGPEI]
	//
	{	m_pCustomVideoRenderer = NULL;

		m_pCustomChannelWindow = NULL;

		m_pOverlayWindowTime = NULL;

		m_pOverlayWindow = NULL;

		m_hVideoDevice = 0xFFFFFFFF;

		m_hAudioDevice = 0xFFFFFFFF;
	}
	// [2010.12.12] [HUENGPEI]
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	{	CRect rect_parent; GetWindowRect( &rect_parent );

		CRect rect_client; GetClientRect( &rect_client );

		ULONG dx = rect_parent.Width() - rect_client.Width();

		ULONG dy = rect_parent.Height() - rect_client.Height();

		SetWindowPos( &CWnd::wndTop, 0, 0, 640 + dx, 480 + dy, 0x00000000 );

	//	SetWindowPos( &CWnd::wndTop, 0, 0, 1280 + dx, 720 + dy, 0x00000000 );

		m_oVideoRendererWindow.Create( NULL, "MyVideoRendererWindow", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 640, 480 ), this, 0, NULL );

	//	m_oVideoRendererWindow.Create( NULL, "MyVideoRendererWindow", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 1280, 720 ), this, 0, NULL );
	}
	{	m_pCustomVideoRenderer = CVRSDK_CREATE();

		if( m_pCustomVideoRenderer == NULL ) { goto CREATE_ERROR; }

		m_pCustomChannelWindow = CVRSDK_INSERT_CHANNEL_WINDOW( m_pCustomVideoRenderer, m_oVideoRendererWindow.m_hWnd, 640, 480 );

		if( m_pCustomChannelWindow == NULL ) { goto CREATE_ERROR; }
	}
	{	m_hVideoDevice = AMESDK_CREATE( "TW6802 PCI", 0, 0, NULL, on_process_video_buffer, this );

		if( m_hVideoDevice & 0x80000000 ) { m_hVideoDevice = 0xFFFFFFFF; goto CREATE_ERROR; }

		m_hAudioDevice = AMESDK_CREATE( "TW6802 PCI, Analog WaveIn", 0, 0, NULL, on_process_audio_buffer, this );

		if( m_hAudioDevice & 0x80000000 ) { m_hAudioDevice = 0xFFFFFFFF; goto CREATE_ERROR; }

		AMESDK_SET_STANDARD( m_hVideoDevice, 0x00000001 );

		AMESDK_SET_FORMAT( m_hVideoDevice, MAKEFOURCC('Y', 'U', 'Y', '2'), 640, 480, 16, 29.970 );

		AMESDK_SET_FORMAT( m_hAudioDevice, 1, 8, 8000 );

		AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDevice, 209, 0x00000001 ); // KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_SCALE_OUTPUT

		AMESDK_RUN( m_hVideoDevice );

		AMESDK_RUN( m_hAudioDevice );
	}
//	{	m_hVideoDevice = AMESDK_CREATE( "DC1150 USB", 0, 0, NULL, on_process_video_buffer, this );
//
//		if( m_hVideoDevice & 0x80000000 ) { m_hVideoDevice = 0xFFFFFFFF; goto CREATE_ERROR; }
//
//		m_hAudioDevice = AMESDK_CREATE( "DC1150 USB, Analog WaveIn", 0, 0, m_hWnd, on_process_audio_buffer, this );
//
//		if( m_hAudioDevice & 0x80000000 ) { m_hAudioDevice = 0xFFFFFFFF; goto CREATE_ERROR; }
//
//		AMESDK_SET_STANDARD( m_hVideoDevice, 0x00000001 );
//
//		AMESDK_SET_FORMAT( m_hVideoDevice, MAKEFOURCC('Y', 'U', 'Y', '2'), 640, 480, 16, 29.970 );
//
//		AMESDK_SET_FORMAT( m_hAudioDevice, 2, 16, 48000 );
//
//		AMESDK_RUN( m_hVideoDevice );
//
//		AMESDK_RUN( m_hAudioDevice );
//	}
//	{	m_hVideoDevice = AMESDK_CREATE( "FH8735 PCI", 0, 0, NULL, on_process_video_buffer, this );
//
//		if( m_hVideoDevice & 0x80000000 ) { m_hVideoDevice = 0xFFFFFFFF; goto CREATE_ERROR; }
//
//		m_hAudioDevice = AMESDK_CREATE( "FH8735 PCI, Analog WaveIn", 0, 0, m_hWnd, on_process_audio_buffer, this );
//
//		if( m_hAudioDevice & 0x80000000 ) { m_hAudioDevice = 0xFFFFFFFF; goto CREATE_ERROR; }
//
//		AMESDK_SET_STANDARD( m_hVideoDevice, 0x00000001 );
//
//		AMESDK_SET_FORMAT( m_hVideoDevice, MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, 12, 29.970 );
//
//		AMESDK_SET_FORMAT( m_hAudioDevice, 2, 16, 48000 );
//
//		AMESDK_RUN( m_hVideoDevice );
//
//		AMESDK_RUN( m_hAudioDevice );
//	}
	{	HDC hMemoryDC = NULL;

		m_pOverlayWindow = CVRSDK_CREATE_OVERLAY_BUFFER( m_pCustomChannelWindow, 330, 60);

		if( CVRSDK_LOCK_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindow, &hMemoryDC ) == TRUE ) { // STATIC OVERYLAY

			Graphics graphics( hMemoryDC );

			graphics.SetSmoothingMode( SmoothingModeAntiAlias );

			graphics.SetInterpolationMode( InterpolationModeHighQualityBicubic );

		//	graphics.FillEllipse( ... );

		//	graphics.DrawLine( ... );

		//	graphics.DrawImage( ... );

			// DRAW COOL STRING
			//
			{	FontFamily o_font_family( L"Arial" );

				wchar_t pszbuf[] = L"http://www.yuan.com.tw";

				GraphicsPath o_path;

				o_path.AddString( pszbuf, -1, &o_font_family, FontStyleRegular, 24, Point( 0, 0 ), NULL );

				for( ULONG i = 0 ; i < 8 ; i++ ) {

					Pen o_pen( Color( 24, 0, 128, 192 ), i + 1.0f );

					o_pen.SetLineJoin( LineJoinRound );

					graphics.DrawPath( &o_pen, &o_path );
				}
				SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );

				graphics.FillPath( &o_solid_brush_white, &o_path );
			}
			CVRSDK_UNLOCK_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindow, hMemoryDC );

			CVRSDK_SHOW_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindow, TRUE, 360, 430 );
		}
	}
	{	SetTimer( 0x00000000, 0, NULL );
	}

CREATE_ERROR:

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC300Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// [2010.12.12] [HUENGPEI]
	//
	{	AMESDK_STOP( m_hVideoDevice );

		AMESDK_STOP( m_hAudioDevice );
	}
	{	if( m_hVideoDevice != 0xFFFFFFFF ) {
		
			AMESDK_DESTROY( m_hVideoDevice ); 
			
			m_hVideoDevice = 0xFFFFFFFF; 
		}
		if( m_hAudioDevice != 0xFFFFFFFF ) {
		
			AMESDK_DESTROY( m_hAudioDevice ); 
			
			m_hAudioDevice = 0xFFFFFFFF;
		}
	}
	{	if( m_pCustomVideoRenderer ) {

			CVRSDK_DESTROY( m_pCustomVideoRenderer );

			m_pCustomVideoRenderer = NULL;
		}
	}
	{	m_oVideoRendererWindow.DestroyWindow();
	}
	{	CoUninitialize();
	}
}

void CSC300Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC300Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC300Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC300Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSC300Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


void CSC300Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	// [2010.12.12] [HUENGPEI]
	//
	if( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		SetTimer( 0x00000000, 1000, NULL );

		HDC hMemoryDC = NULL;

		if(m_pOverlayWindowTime == NULL)
		{
			m_pOverlayWindowTime = CVRSDK_CREATE_OVERLAY_BUFFER(m_pCustomChannelWindow, 330, 60);
		}

		if( CVRSDK_LOCK_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindowTime, &hMemoryDC ) == TRUE ) { // DYNAMIC OVERYLAY

			SYSTEMTIME s_system_time; GetLocalTime( &s_system_time );

			SolidBrush o_solid_brush_black( Color( 255,   0,   0,   0 ) );

			SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );

			Font o_font( L"Terminal", 32, FontStyleBold );

			Graphics graphics( hMemoryDC );

			graphics.SetSmoothingMode( SmoothingModeHighSpeed );

			graphics.SetInterpolationMode( InterpolationModeLowQuality );

			CHAR psz[ 32 ];
					
			sprintf( psz, "CH00 %02d:%02d:%02d", s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );

			graphics.DrawString( _bstr_t(psz), -1, &o_font, RectF( 0, 1, 640, 48 ), NULL, &o_solid_brush_black );

			graphics.DrawString( _bstr_t(psz), -1, &o_font, RectF( 1, 0, 640, 48 ), NULL, &o_solid_brush_black );

			graphics.DrawString( _bstr_t(psz), -1, &o_font, RectF( 2, 1, 640, 48 ), NULL, &o_solid_brush_black );

			graphics.DrawString( _bstr_t(psz), -1, &o_font, RectF( 1, 2, 640, 48 ), NULL, &o_solid_brush_black );

			graphics.DrawString( _bstr_t(psz), -1, &o_font, RectF( 1, 1, 640, 48 ), NULL, &o_solid_brush_white );

			CVRSDK_UNLOCK_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindowTime, hMemoryDC );

			CVRSDK_SHOW_OVERLAY_BUFFER( m_pCustomChannelWindow, m_pOverlayWindowTime, TRUE, 0, 0 );
		}
	}
	CDialog::OnTimer(nIDEvent);
}

void CSC300Dlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nChar == ' ' ) { // PUSH "SPACE" TO SNAPSHOT

		SYSTEMTIME s_system_time; GetLocalTime( &s_system_time );

		CHAR psz[ 32 ];

		sprintf( psz, "%04d%02d%02d%02d%02d%02d.BMP", s_system_time.wYear, s_system_time.wMonth, s_system_time.wDay, s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );
	
		CVRSDK_SNAPSHOT_BMP( m_pCustomVideoRenderer, psz ); // DEMO#01

	//	CVRSDK_SNAPSHOT_BMP( m_pCustomVideoRenderer, m_pCustomChannelWindow, psz ); // DEMO#02

		sprintf( psz, "%04d%02d%02d%02d%02d%02d.JPG", s_system_time.wYear, s_system_time.wMonth, s_system_time.wDay, s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );
	
	//	CVRSDK_SNAPSHOT_JPG( m_pCustomVideoRenderer, psz ); // DEMO#03

	//	CVRSDK_SNAPSHOT_JPG( m_pCustomVideoRenderer, m_pCustomChannelWindow, psz ); // DEMO#04
	}
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CSC300Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return TRUE;

	return CDialog::OnEraseBkgnd(pDC);
}

void CSC300Dlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	::MoveWindow( m_oVideoRendererWindow.m_hWnd, 0, 0, cx, cy, 0 );
	
	CVRSDK_RESIZE_CHANNEL_WINDOW( m_pCustomChannelWindow );
}
