// AudioInputPanel.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "AudioInputPanel.h"

#include "MultiRecoderDemoDlg.h"
#include "LivePropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAudioInputPanel dialog


CAudioInputPanel::CAudioInputPanel(CWnd* pParent /*=NULL*/)
	: CDialog(CAudioInputPanel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAudioInputPanel)
	m_staticAudioVolume = _T("");
	//}}AFX_DATA_INIT
}


void CAudioInputPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAudioInputPanel)
	DDX_Control(pDX, IDC_SLIDER_VOLUME, m_sldAudioVolume);
	DDX_Text(pDX, IDC_STATIC_AUDIO_VOLUME, m_staticAudioVolume);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAudioInputPanel, CDialog)
	//{{AFX_MSG_MAP(CAudioInputPanel)
	ON_BN_CLICKED(IDC_RADIO_INPUT_EMBEDDED_AUDIO, OnRadioInputEmbeddedAudio)
	ON_BN_CLICKED(IDC_RADIO_INPUT_LINEIN, OnRadioInputLinein)
	ON_BN_CLICKED(IDC_BUTTON_Apply, OnBUTTONApply)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_VOLUME, OnReleasedcaptureSliderVolume)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAudioInputPanel message handlers

void CAudioInputPanel::OnOK() {


	//CDialog::OnOK();
}

void CAudioInputPanel::OnCancel() {


	//CDialog::OnCancel();
}

BOOL CAudioInputPanel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_AUDIO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nAudioInput[ nChannelNum ] );

	if ( pMainDlg->m_nAudioInput[ nChannelNum ] == 0 ) { CheckDlgButton( IDC_RADIO_INPUT_EMBEDDED_AUDIO, BST_CHECKED ); }

	if ( pMainDlg->m_nAudioInput[ nChannelNum ] == 1 ) { CheckDlgButton( IDC_RADIO_INPUT_LINEIN, BST_CHECKED ); }	

	// SETTING VIDEO VOLUME 
	//
	m_sldAudioVolume.SetRange( 0, 100, TRUE );

	// SET VALUES 
	CHAR sz[ MAX_PATH ] = { 0 };

	QCAP_SET_AUDIO_VOLUME( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nAudioVolume[ nChannelNum ] );

	m_sldAudioVolume.SetPos( pMainDlg->m_nAudioVolume[ nChannelNum ] );

	itoa( pMainDlg->m_nAudioVolume[ nChannelNum ], sz, 10 );

	m_staticAudioVolume = (LPTSTR)sz;

	UpdateData( FALSE );		

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAudioInputPanel::OnRadioInputEmbeddedAudio() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nAudioInput[ nChannelNum ] = 0x00000000;

	QCAP_SET_AUDIO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nAudioInput[ nChannelNum ] );
}

void CAudioInputPanel::OnRadioInputLinein() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nAudioInput[ nChannelNum ] = 0x00000001;

	QCAP_SET_AUDIO_INPUT( pMainDlg->m_hVideoDevice[ nChannelNum ], pMainDlg->m_nAudioInput[ nChannelNum ] );	
}

void CAudioInputPanel::OnBUTTONApply() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );

	CDialog::OnOK();	
}

void CAudioInputPanel::OnReleasedcaptureSliderVolume(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	QCAP_SET_AUDIO_VOLUME( pMainDlg->m_hVideoDevice[ nChannelNum ], m_sldAudioVolume.GetPos() );

	CHAR sz[ MAX_PATH ] = { 0 };

	itoa(m_sldAudioVolume.GetPos(), sz, 10 );

	m_staticAudioVolume = (LPTSTR)sz;

	pMainDlg->m_nAudioVolume[ nChannelNum ] = m_sldAudioVolume.GetPos();

	UpdateData( FALSE );		

	*pResult = 0;
}
