﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo
{
    public partial class MyAdvancedSettingsDlg : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public Form1 m_pMainForm;

        public uint i = 0;        

        public string m_strCurrentDir = "";

        public uint m_nChannelNumber = 0;

        public string[] m_strRecordFilePath = new string[6], m_strRecordFileNameRule =  new string[6];        

        public string[] m_strSnapshotFilePath = new string[6];

        public bool[] m_bAutoDeinterlace = new bool[6];

        public bool[] m_bSupportGPU = new bool[6];        

        public bool[] m_bCheckedAVI = new bool[6], m_bCheckedMP4 = new bool[6];        

        public uint[] m_nVideoStandard = new uint[6];        

        public double[] m_dFrameRate = new double[6];        

        public uint[] m_nEncoderType = new uint[6], m_nEncoderFormat = new uint[6];        

        public uint[] m_nEncoderWidth = new uint[6], m_nEncoderHeight = new uint[6];        

        public uint[] m_nAudioEncoderFormat = new uint[6];        

        public uint[] m_nRecordMode = new uint[6], m_nQuality = new uint[6], m_nBitRate = new uint[6], m_nGOP = new uint[6], m_DownloadScaleMode = new  uint[6];                

        public uint[] m_nContinuousSnapshots = new uint[6], m_nContinuousSnapshotsDuration = new uint[6];        

        // OSD
        //
        public string[] m_pszString = new string[6];

        public string[] m_pszFontFamilyName = new string[6];

        public Color[] m_clrFontForeground = new Color[6], m_clrFontBackground = new Color[6];

        public uint[] m_dwBackgroundColorTransparent = new uint[6];

        public uint[] m_nOsdNum1 = new uint[6], m_nOsdNum2 = new uint[6], m_nOsdNum3 = new uint[6];        

        public uint[] m_dwFontColor = new uint[6];

        public uint[] m_dwFontColorTransparent = new uint[6];

        public uint[] m_nFontSize = new  uint[6], m_nFontStyle = new uint[6];

        public uint[] m_xoffset1 = new uint[6], m_xoffset2 = new uint[6], m_xoffset3 = new uint[6];

        public uint[] m_yoffset1 = new uint[6], m_yoffset2 = new uint[6], m_yoffset3 = new uint[6];

        public uint[] m_width1 = new uint[6], m_width2 = new uint[6], m_width3 = new uint[6];

        public uint[] m_height1 = new uint[6], m_height2 = new uint[6], m_height3 = new uint[6];

        public uint[] m_nTransparent1 = new uint[6], m_nTransparent2 = new uint[6], m_nTransparent3 = new uint[6];

        public string[] m_strPicturePath = new string[6];

        public Bitmap[] m_PicImage = new Bitmap[6];

        // CONVERT COLOR TO UINT
        //
        private uint ColorToUInt(Color color)
        {
            return (uint)((color.A << 24) | (color.R << 16) | (color.G << 8) | (color.B << 0));
        }

        // CONVERT UINT TO COLORs
        //
        private Color UIntToColor(uint color)
        {
            byte a = (byte)(color >> 24);
            byte r = (byte)(color >> 16);
            byte g = (byte)(color >> 8);
            byte b = (byte)(color >> 0);

            return Color.FromArgb(a, r, g, b);
        }

        // DEVICE PROPERTY
        //
        public uint[] m_hCapDev = new uint[6];                         // STREAM CAPTURE DEVICE

        public uint[] m_hCloneCapDev = new uint[6];                // CLONE STREAM CAPTURE DEVICE

        public MyAdvancedSettingsDlg()
        {
            InitializeComponent();
        }

        private void MyAdvancedSettingsDlg_Load(object sender, EventArgs e)
        {
            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            textBoxRecordPath.Text = m_strCurrentDir;

            textBoxSnapshotPath.Text = m_strCurrentDir;

            // GET CURRENT DIRECTORY
            //
            for (i = 0; i < 6; i++)
            {
                m_strRecordFilePath[i] = m_strCurrentDir;

                m_bAutoDeinterlace[i] = false;  m_bSupportGPU[i] = false;                

                m_bCheckedAVI[i] = true; m_bCheckedMP4[i] = false;                

                m_nContinuousSnapshots[i] = 3;

                m_nContinuousSnapshotsDuration[i] = 10;

                m_nVideoStandard[i] = 0;              

                m_dFrameRate[i] = 30.0;                

                m_nEncoderWidth[i] = 1920; m_nEncoderHeight[i] = 1080;                

                m_nEncoderType[i] = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;                

                m_nEncoderFormat[i] = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;                

                m_nAudioEncoderFormat[i] = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;                

                m_nRecordMode[i] = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR;                

                m_DownloadScaleMode[i] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF;                

                m_nQuality[i] = 8000;

                m_nBitRate[i] = 12582912;                

                m_nGOP[i] = 30;                
            }            

            for (i = 0; i < 6; i++)
            {
                m_pszString[i] = "YUAN";

                m_pszFontFamilyName[i] = "Arial";

                m_nOsdNum1[i] = 0; m_nOsdNum2[i] = 0; m_nOsdNum3[i] = 0;

                m_dwFontColor[i] = 0;

                m_dwFontColorTransparent[i] = 0;

                m_dwBackgroundColorTransparent[i] = 0;

                m_nFontSize[i] = 0;

                m_nFontStyle[i] = (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_REGULAR;

                m_xoffset1[i] = 0; m_xoffset2[i] = 0; m_xoffset3[i] = 0;

                m_yoffset1[i] = 0; m_yoffset2[i] = 0; m_yoffset3[i] = 0;

                m_width1[i] = 320; m_width2[i] = 320; m_width3[i] = 320;

                m_height1[i] = 240; m_height2[i] = 240; m_height3[i] = 240;

                m_nTransparent1[i] = 255; m_nTransparent2[i] = 255; m_nTransparent3[i] = 255;

                m_strPicturePath[i] = "";

                m_PicImage[i] = null;
            }

            comboVideoStandard.SelectedIndex = 0; 

            comboFrameRate.SelectedIndex = 0; 

            comboVideoFormat.SelectedIndex = 0; 

            comboAudioFormat.SelectedIndex = 0;

            comboRecordMode.SelectedIndex = 0;

            comboBitrate.SelectedIndex = 0;

            comboQuality.SelectedIndex = 0;

            comboGOP.SelectedIndex = 29;

            comboDownloadScaleMode.SelectedIndex = 0;

            comboxOSDLayer1.SelectedIndex = 0; 

            comboxFontSize1.SelectedIndex = 9;

            comboxOSDLayer2.SelectedIndex = 1;

            comboxFontColorTransparent.SelectedIndex = 0;

            comboxBackgroundColorTransparent.SelectedIndex = 0;
        }

        private void MyAdvancedSettingsDlg_FormClosed(object sender, FormClosedEventArgs e)
        {

        }

        private void tabControlAdvancedSettings_Enter(object sender, EventArgs e)
        {
            
        }

        private void tabControlAdvancedSettings_Leave(object sender, EventArgs e)
        {
           
        }

        private void tabControlAdvancedSettings_TabIndexChanged(object sender, EventArgs e)
        {

        }

        private void pageShareRecording_Enter(object sender, EventArgs e)
        {

        }

        private void pageShareRecording_Leave(object sender, EventArgs e)
        {

        }

        private void pageVideoInput_Enter(object sender, EventArgs e)
        {            
            OutputDebugString("Enter Video Input Page ! \n");

            if (m_hCloneCapDev[m_nChannelNumber] == 0)
            {
                if (m_hCapDev[m_nChannelNumber] != 0x00000000)
                {
                    uint nInput = (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI;

                    EXPORTS.QCAP_GET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], ref nInput);

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPOSITE) { RadioButtonCOMPOSITE.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SVIDEO) { RadioButtonSVIDEO.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_HDMI) { RadioButtonInputHDMI.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_D) { RadioButtonInputDVI.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPONENTS) { RadioButtonYCBCR.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_A) { RadioButtonRGB.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI) { RadioButtonSDI.Checked = true; }

                    if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO) { RadioButtonAUTO.Checked = true; }

                    uint nBrightness = 0;

                    EXPORTS.QCAP_GET_VIDEO_BRIGHTNESS(m_hCapDev[m_nChannelNumber], ref nBrightness);

                    m_sliderBrightness.Value = (int)nBrightness;

                    m_staticBrightness.Text = nBrightness.ToString();

                    uint nContrast = 0;

                    EXPORTS.QCAP_GET_VIDEO_CONTRAST(m_hCapDev[m_nChannelNumber], ref nContrast);

                    m_sliderContrast.Value = (int)nContrast;

                    m_staticContrast.Text = nContrast.ToString();

                    uint nHue = 0;

                    EXPORTS.QCAP_GET_VIDEO_HUE(m_hCapDev[m_nChannelNumber], ref nHue);

                    m_sliderHue.Value = (int)nHue;

                    m_staticHue.Text = nHue.ToString();

                    uint nSaturation = 0;

                    EXPORTS.QCAP_GET_VIDEO_SATURATION(m_hCapDev[m_nChannelNumber], ref nSaturation);

                    m_sliderSaturation.Value = (int)nSaturation;

                    m_staticSaturation.Text = nSaturation.ToString();

                    uint nSharpness = 0;

                    EXPORTS.QCAP_GET_VIDEO_SHARPNESS(m_hCapDev[m_nChannelNumber], ref nSharpness);

                    m_sliderSharpness.Value = (int)nSharpness;

                    m_staticSharpness.Text = nSharpness.ToString();

                    nInput = (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

                    EXPORTS.QCAP_GET_AUDIO_INPUT(m_hCapDev[m_nChannelNumber], ref nInput);

                    if (nInput == (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO)
                    {
                        RadioButtonInputEMBEDDEDAUDIO.Checked = true;
                    }

                    if (nInput == (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_LINE_IN)
                    {
                        RadioButtonInputEMBEDDEDLINEIN.Checked = true;
                    }

                    uint nVolume = 0;

                    EXPORTS.QCAP_GET_AUDIO_VOLUME(m_hCapDev[m_nChannelNumber], ref nVolume);

                    trackBarAudioVolume.Value = (int)nVolume;

                    m_staticAudioVolumeB.Text = nVolume.ToString();

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[m_nChannelNumber], (uint)panelVideoPreview1.Handle.ToInt32(), ref m_hCloneCapDev[m_nChannelNumber], 1);

                    EXPORTS.QCAP_RUN(m_hCloneCapDev[m_nChannelNumber]);
                }
            }            
        }

        private void pageVideoInput_Leave(object sender, EventArgs e)
        {            
            OutputDebugString("Leave Video Input Page ! \n");

            if (m_hCloneCapDev[m_nChannelNumber] != 0)
            {
                EXPORTS.QCAP_STOP(m_hCloneCapDev[m_nChannelNumber]);

                EXPORTS.QCAP_DESTROY(m_hCloneCapDev[m_nChannelNumber]); m_hCloneCapDev[m_nChannelNumber] = 0;

                m_hCloneCapDev[m_nChannelNumber] = 0;
            }            
        }

        private void pageAudioInput_Enter(object sender, EventArgs e)
        {            
        }

        private void pageAudioInput_Leave(object sender, EventArgs e)
        {

        }

        private void pageRecording_Enter(object sender, EventArgs e)
        {

        }

        private void pageRecording_Leave(object sender, EventArgs e)
        {

        }

        private void pageSnapshot_Enter(object sender, EventArgs e)
        {

        }

        private void pageSnapshot_Leave(object sender, EventArgs e)
        {

        }

        private void pageOSD_Enter(object sender, EventArgs e)
        {            
            OutputDebugString("Enter Video Input Page ! \n");

             if (m_hCloneCapDev[m_nChannelNumber] == 0)
            {
                if (m_hCapDev[m_nChannelNumber] != 0x00000000)
                {
                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[m_nChannelNumber],  (uint)panelVideoPreview2.Handle.ToInt32(), ref m_hCloneCapDev[m_nChannelNumber], 1);

                    EXPORTS.QCAP_RUN(m_hCloneCapDev[m_nChannelNumber]);
                }
             }            
        }

        private void pageOSD_Leave(object sender, EventArgs e)
        {            
            OutputDebugString("Leave Video Input Page ! \n");

            if (m_hCloneCapDev[m_nChannelNumber] != 0)
            {
                EXPORTS.QCAP_STOP(m_hCloneCapDev[m_nChannelNumber]);

                EXPORTS.QCAP_DESTROY(m_hCloneCapDev[m_nChannelNumber]); m_hCloneCapDev[m_nChannelNumber] = 0;

                m_hCloneCapDev[m_nChannelNumber] = 0;
            }             
        }

        private void pageSystem_Enter(object sender, EventArgs e)
        {            
        }        

        private void pageSystem_Leave(object sender, EventArgs e)
        {

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Hide();
            
            m_nContinuousSnapshots[m_nChannelNumber] = (uint)numUpDownContinuousSnapshots.Value;

            m_pMainForm.m_nContinuousSnapshots[m_nChannelNumber] = m_nContinuousSnapshots[m_nChannelNumber];

            m_nContinuousSnapshotsDuration[m_nChannelNumber] = (uint)numUpDownContinuousSnapshotsDuration.Value;

            m_pMainForm.m_nContinuousSnapshotsDuration[m_nChannelNumber] = m_nContinuousSnapshotsDuration[m_nChannelNumber];

            m_pMainForm.m_bSupportGPU[m_nChannelNumber] = m_bSupportGPU[m_nChannelNumber];            

            m_pMainForm.m_bCheckedAVI[m_nChannelNumber] = m_bCheckedAVI[m_nChannelNumber];

            m_pMainForm.m_bCheckedMP4[m_nChannelNumber] = m_bCheckedMP4[m_nChannelNumber];            

            m_pMainForm.m_nVideoStandard[m_nChannelNumber] = m_nVideoStandard[m_nChannelNumber];            

            m_pMainForm.m_dFrameRate[m_nChannelNumber] = m_dFrameRate[m_nChannelNumber];            

            m_pMainForm.m_nEncoderWidth[m_nChannelNumber] = m_nEncoderWidth[m_nChannelNumber];

            m_pMainForm.m_nEncoderHeight[m_nChannelNumber] = m_nEncoderHeight[m_nChannelNumber];            

            m_pMainForm.m_nEncoderType[m_nChannelNumber] = m_nEncoderType[m_nChannelNumber];            

            m_pMainForm.m_nEncoderFormat[m_nChannelNumber] = m_nEncoderFormat[m_nChannelNumber];            

            m_pMainForm.m_nAudioEncoderFormat[m_nChannelNumber] = m_nAudioEncoderFormat[m_nChannelNumber];            

            m_pMainForm.m_nRecordMode[m_nChannelNumber] = m_nRecordMode[m_nChannelNumber];            

            m_pMainForm.m_DownloadScaleMode[m_nChannelNumber] = m_DownloadScaleMode[m_nChannelNumber];            

            m_pMainForm.m_nQuality[m_nChannelNumber] = m_nQuality[m_nChannelNumber];            

            m_pMainForm.m_nBitRate[m_nChannelNumber] = m_nBitRate[m_nChannelNumber];            

            m_pMainForm.m_nGOP[m_nChannelNumber] = m_nGOP[m_nChannelNumber];             

            m_pMainForm.m_strRecordFilePath[m_nChannelNumber] = m_strRecordFilePath[m_nChannelNumber];

            if (m_bSupportGPU[m_nChannelNumber])
            {
                m_nEncoderType[m_nChannelNumber] = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK;

                m_pMainForm.m_nEncoderType[m_nChannelNumber] = m_nEncoderType[m_nChannelNumber];
            }
            else
            {
                m_nEncoderType[m_nChannelNumber] = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;

                m_pMainForm.m_nEncoderType[m_nChannelNumber] = m_nEncoderType[m_nChannelNumber];
            }                  
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Hide();
        }        

        private void RadioButtonInputHDMI_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_HDMI);
            }                       
        }

        private void RadioButtonInputDVI_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_D);
            }            
        }

        private void RadioButtonYCBCR_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPONENTS);
            }            
        }

        private void RadioButtonRGB_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_A);
            }            
        }

        private void RadioButtonSDI_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI);
            }          
        }

        private void RadioButtonCOMPOSITE_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPOSITE);
            }          
        }

        private void RadioButtonSVIDEO_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SVIDEO);
            }            
        }

        private void RadioButtonAUTO_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO);
            }            
        }

        private void m_sliderBrightness_Scroll(object sender, EventArgs e)
        {            
            int n_property_value = m_sliderBrightness.Value;

            m_staticBrightness.Text = n_property_value.ToString();

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev[m_nChannelNumber], (uint)n_property_value);
            }          
        }

        private void m_sliderContrast_Scroll(object sender, EventArgs e)
        {            
            int n_property_value = m_sliderContrast.Value;

            m_staticContrast.Text = n_property_value.ToString();

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev[m_nChannelNumber], (uint)n_property_value);
            }          
        }

        private void m_sliderHue_Scroll(object sender, EventArgs e)
        {            
            int n_property_value = m_sliderHue.Value;

            m_staticHue.Text = n_property_value.ToString();

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev[m_nChannelNumber], (uint)n_property_value);
            }            
        }

        private void m_sliderSaturation_Scroll(object sender, EventArgs e)
        {            
            int n_property_value = m_sliderSaturation.Value;

            m_staticSaturation.Text = n_property_value.ToString();

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev[m_nChannelNumber], (uint)n_property_value);
            }            
        }

        private void m_sliderSharpness_Scroll(object sender, EventArgs e)
        {            
            int n_property_value = m_sliderSharpness.Value;

            m_staticSharpness.Text = n_property_value.ToString();

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev[m_nChannelNumber], (uint)n_property_value);
            }          
        }

        private void btnDefaultVideoProperty_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                m_sliderBrightness.Value = 128;

                m_staticBrightness.Text = "128";

                EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev[m_nChannelNumber], 128);

                m_sliderContrast.Value = 128;

                m_staticContrast.Text = "128";

                EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev[m_nChannelNumber], 128);

                m_sliderHue.Value = 128;

                m_staticHue.Text = "128";

                EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev[m_nChannelNumber], 128);

                m_sliderSaturation.Value = 128;

                m_staticSaturation.Text = "128";

                EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev[m_nChannelNumber], 128);

                m_sliderSharpness.Value = 128;

                m_staticSharpness.Text = "128";

                EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev[m_nChannelNumber], 128);
            }                       
        }

        private void RadioButtonInputEMBEDDEDAUDIO_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_AUDIO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO);
            }          
        }

        private void RadioButtonInputEMBEDDEDLINEIN_Click(object sender, EventArgs e)
        {            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_AUDIO_INPUT(m_hCapDev[m_nChannelNumber], (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_LINE_IN);
            }          
        }

        private void trackBarAudioVolume_Scroll(object sender, EventArgs e)
        {            
            int nVolume = trackBarAudioVolume.Value;            

            m_staticAudioVolumeB.Text = nVolume.ToString();
            
            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCapDev[m_nChannelNumber], (uint)nVolume);
            }          
        }

        private void btnBrowseRecordPath_Click(object sender, EventArgs e)
        {            
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "Open a folder to save record files";

                dialog.ShowNewFolderButton = false;

                dialog.RootFolder = Environment.SpecialFolder.MyComputer;

                m_strRecordFilePath[m_nChannelNumber] = m_pMainForm.m_strRecordFilePath[m_nChannelNumber];

                dialog.SelectedPath = m_strRecordFilePath[m_nChannelNumber];

                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    m_strRecordFilePath[m_nChannelNumber] = dialog.SelectedPath;

                    m_pMainForm.m_strRecordFilePath[m_nChannelNumber] = m_strRecordFilePath[m_nChannelNumber];

                    textBoxRecordPath.Text = m_strRecordFilePath[m_nChannelNumber];
                }
            }            
        }

        private void m_checkAVI_Click(object sender, EventArgs e)
        {          
            m_checkAVI.Checked = true;

            m_checkMP4.Checked = false;

            m_bCheckedAVI[m_nChannelNumber] = true;

            m_bCheckedMP4[m_nChannelNumber] = false;            
        }

        private void m_checkMP4_Click(object sender, EventArgs e)
        {            
            m_checkAVI.Checked = false;

            m_checkMP4.Checked = true;

            m_bCheckedAVI[m_nChannelNumber] = false;

            m_bCheckedMP4[m_nChannelNumber] = true;            
        }

        private void m_checkGPU_Click(object sender, EventArgs e)
        {
           m_bSupportGPU[m_nChannelNumber] = m_checkGPU.Checked;
        }

        private void comboVideoStandard_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboVideoStandard.SelectedIndex == 0) // NTSC
            {
                m_nVideoStandard[m_nChannelNumber] = 0;

                comboFrameRate.Items.Clear();

                comboFrameRate.Items.Add("30.0 (fps)");

                comboFrameRate.Items.Add("15.0 (fps)");

                comboFrameRate.Items.Add(" 7.5 (fps)");

                comboFrameRate.SelectedIndex = 0;

                comboBoxResolution.Items.Clear();

                comboBoxResolution.Items.Add("1920 x 1080 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("1280 x   720 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("  720 x   480 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  704 x   480 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  640 x   480 ( VGA Resolution )");
                comboBoxResolution.Items.Add("  360 x   240 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  352 x   240 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  320 x   240 ( VCD Resolution )");

                comboBoxResolution.SelectedIndex = 0;             
            }

            if (comboVideoStandard.SelectedIndex == 1) // PAL
            {
                m_nVideoStandard[m_nChannelNumber] = 1;                

                comboFrameRate.Items.Clear();

                comboFrameRate.Items.Add("25.0 (fps)");

                comboFrameRate.Items.Add("12.5 (fps)");

                comboFrameRate.Items.Add(" 6.25 (fps)");

                comboFrameRate.SelectedIndex = 0;

                comboBoxResolution.Items.Clear();

                comboBoxResolution.Items.Add("1920 x 1080 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("1280 x   720 ( HD 1080p Resolution ) ");
                comboBoxResolution.Items.Add("  720 x   576 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  704 x   576 ( DVD Resolution )");
                comboBoxResolution.Items.Add("  640 x   576 ( VGA Resolution )");
                comboBoxResolution.Items.Add("  360 x   288 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  352 x   288 ( VCD Resolution )");
                comboBoxResolution.Items.Add("  320 x   288 ( VCD Resolution )");

                comboBoxResolution.SelectedIndex = 0;                
            }            
        }

        private void comboFrameRate_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboVideoStandard.SelectedIndex == 0)
            {
                if (comboFrameRate.SelectedIndex == 0) { m_dFrameRate[m_nChannelNumber] = 30.0; }

                if (comboFrameRate.SelectedIndex == 1) { m_dFrameRate[m_nChannelNumber] = 15.0; }

                if (comboFrameRate.SelectedIndex == 2) { m_dFrameRate[m_nChannelNumber] = 7.5; }
            }

            if (comboVideoStandard.SelectedIndex == 1)
            {
                if (comboFrameRate.SelectedIndex == 0) { m_dFrameRate[m_nChannelNumber] = 25.0; }

                if (comboFrameRate.SelectedIndex == 1) { m_dFrameRate[m_nChannelNumber] = 12.5; }

                if (comboFrameRate.SelectedIndex == 2) { m_dFrameRate[m_nChannelNumber] = 6.25; }
            }            
        }

        private void comboVideoFormat_SelectedIndexChanged(object sender, EventArgs e)
        {
           m_nEncoderFormat[m_nChannelNumber] = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;
        }

        private void comboAudioFormat_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboAudioFormat.SelectedIndex == 0)
            {
                m_nAudioEncoderFormat[m_nChannelNumber] = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;
            }

            if (comboAudioFormat.SelectedIndex == 1)
            {
                m_nAudioEncoderFormat[m_nChannelNumber] = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC;
            }            
        }

        private void comboBoxResolution_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboBoxResolution.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 1920; m_nEncoderHeight[m_nChannelNumber] = 1080; }

            if (comboBoxResolution.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 1280; m_nEncoderHeight[m_nChannelNumber] = 720; }

            if (comboBoxResolution.SelectedIndex == 2 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 720; m_nEncoderHeight[m_nChannelNumber] = 480; }

            if (comboBoxResolution.SelectedIndex == 3 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 704; m_nEncoderHeight[m_nChannelNumber] = 480; }

            if (comboBoxResolution.SelectedIndex == 4 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 640; m_nEncoderHeight[m_nChannelNumber] = 480; }

            if (comboBoxResolution.SelectedIndex == 5 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 360; m_nEncoderHeight[m_nChannelNumber] = 240; }

            if (comboBoxResolution.SelectedIndex == 6 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 352; m_nEncoderHeight[m_nChannelNumber] = 240; }

            if (comboBoxResolution.SelectedIndex == 7 && comboVideoStandard.SelectedIndex == 0) { m_nEncoderWidth[m_nChannelNumber] = 320; m_nEncoderHeight[m_nChannelNumber] = 240; }

            if (comboBoxResolution.SelectedIndex == 2 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 720; m_nEncoderHeight[m_nChannelNumber] = 576; }

            if (comboBoxResolution.SelectedIndex == 3 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 704; m_nEncoderHeight[m_nChannelNumber] = 576; }

            if (comboBoxResolution.SelectedIndex == 4 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 640; m_nEncoderHeight[m_nChannelNumber] = 576; }

            if (comboBoxResolution.SelectedIndex == 5 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 360; m_nEncoderHeight[m_nChannelNumber] = 288; }

            if (comboBoxResolution.SelectedIndex == 6 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 352; m_nEncoderHeight[m_nChannelNumber] = 288; }

            if (comboBoxResolution.SelectedIndex == 7 && comboVideoStandard.SelectedIndex == 1) { m_nEncoderWidth[m_nChannelNumber] = 320; m_nEncoderHeight[m_nChannelNumber] = 288; }            
        }

        private void comboRecordMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboRecordMode.SelectedIndex == 0) { m_nRecordMode[m_nChannelNumber] = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR; }

            if (comboRecordMode.SelectedIndex == 1) { m_nRecordMode[m_nChannelNumber] = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_VBR; }            
        }

        private void comboBitrate_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboBitrate.SelectedIndex == 0) { m_nBitRate[m_nChannelNumber] = 12582912; }

            if (comboBitrate.SelectedIndex == 1) { m_nBitRate[m_nChannelNumber] = 10485760; }

            if (comboBitrate.SelectedIndex == 2) { m_nBitRate[m_nChannelNumber] = 8388608; }

            if (comboBitrate.SelectedIndex == 3) { m_nBitRate[m_nChannelNumber] = 6291456; }

            if (comboBitrate.SelectedIndex == 4) { m_nBitRate[m_nChannelNumber] = 4194304; }

            if (comboBitrate.SelectedIndex == 5) { m_nBitRate[m_nChannelNumber] = 3145728; }

            if (comboBitrate.SelectedIndex == 6) { m_nBitRate[m_nChannelNumber] = 2097152; }

            if (comboBitrate.SelectedIndex == 7) { m_nBitRate[m_nChannelNumber] = 1572864; }

            if (comboBitrate.SelectedIndex == 8) { m_nBitRate[m_nChannelNumber] = 1048576; }

            if (comboBitrate.SelectedIndex == 9) { m_nBitRate[m_nChannelNumber] = 786432; }

            if (comboBitrate.SelectedIndex == 10) { m_nBitRate[m_nChannelNumber] = 524288; }

            if (comboBitrate.SelectedIndex == 11) { m_nBitRate[m_nChannelNumber] = 262144; }

            if (comboBitrate.SelectedIndex == 12) { m_nBitRate[m_nChannelNumber] = 131072; }

            if (comboBitrate.SelectedIndex == 13) { m_nBitRate[m_nChannelNumber] = 65536; }                   
        }

        private void comboQuality_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboQuality.SelectedIndex == 0) { m_nQuality[m_nChannelNumber] = 10000; }

            if (comboQuality.SelectedIndex == 1) { m_nQuality[m_nChannelNumber] = 9500; }

            if (comboQuality.SelectedIndex == 2) { m_nQuality[m_nChannelNumber] = 9000; }

            if (comboQuality.SelectedIndex == 3) { m_nQuality[m_nChannelNumber] = 8500; }

            if (comboQuality.SelectedIndex == 4) { m_nQuality[m_nChannelNumber] = 8000; }

            if (comboQuality.SelectedIndex == 5) { m_nQuality[m_nChannelNumber] = 7500; }

            if (comboQuality.SelectedIndex == 6) { m_nQuality[m_nChannelNumber] = 7000; }

            if (comboQuality.SelectedIndex == 7) { m_nQuality[m_nChannelNumber] = 6500; }

            if (comboQuality.SelectedIndex == 8) { m_nQuality[m_nChannelNumber] = 6000; }

            if (comboQuality.SelectedIndex == 9) { m_nQuality[m_nChannelNumber] = 5500; }

            if (comboQuality.SelectedIndex == 10) { m_nQuality[m_nChannelNumber] = 5000; }

            if (comboQuality.SelectedIndex == 11) { m_nQuality[m_nChannelNumber] = 4500; }

            if (comboQuality.SelectedIndex == 12) { m_nQuality[m_nChannelNumber] = 4000; }

            if (comboQuality.SelectedIndex == 13) { m_nQuality[m_nChannelNumber] = 3500; }

            if (comboQuality.SelectedIndex == 14) { m_nQuality[m_nChannelNumber] = 3000; }

            if (comboQuality.SelectedIndex == 15) { m_nQuality[m_nChannelNumber] = 2500; }

            if (comboQuality.SelectedIndex == 16) { m_nQuality[m_nChannelNumber] = 2000; }

            if (comboQuality.SelectedIndex == 17) { m_nQuality[m_nChannelNumber] = 1500; }

            if (comboQuality.SelectedIndex == 18) { m_nQuality[m_nChannelNumber] = 1000; }

            if (comboQuality.SelectedIndex == 19) { m_nQuality[m_nChannelNumber] = 500; }

            if (comboQuality.SelectedIndex == 20) { m_nQuality[m_nChannelNumber] = 0; }            
        }

        private void comboGOP_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nGOP[m_nChannelNumber] = (uint)comboGOP.SelectedIndex + 1;
        }

        private void m_checkAutoDeinterlace_Click(object sender, EventArgs e)
        {            
            m_bAutoDeinterlace[m_nChannelNumber] = m_checkAutoDeinterlace.Checked;

            if (m_hCapDev[m_nChannelNumber] != 0x00000000)
            {
                if (m_bAutoDeinterlace[m_nChannelNumber])
                    EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[m_nChannelNumber], 1);
                else
                    EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[m_nChannelNumber], 0);
            }            
        }

        private void btnBrowseSnapshotPath_Click(object sender, EventArgs e)
        {            
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "Open a folder to save AVI files";

                dialog.ShowNewFolderButton = false;

                dialog.RootFolder = Environment.SpecialFolder.MyComputer;

                m_strSnapshotFilePath[m_nChannelNumber] = m_pMainForm.m_strSnapshotFilePath[m_nChannelNumber];

                dialog.SelectedPath = m_strSnapshotFilePath[m_nChannelNumber];

                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    m_strSnapshotFilePath[m_nChannelNumber] = dialog.SelectedPath;

                    m_pMainForm.m_strSnapshotFilePath[m_nChannelNumber] = m_strSnapshotFilePath[m_nChannelNumber];

                    textBoxSnapshotPath.Text = m_strSnapshotFilePath[m_nChannelNumber];
                }
            }            
        }        

        private void btnChangeFont_Click(object sender, EventArgs e)
        {            
            fontDialog1.Color = txtBoxTypeString.ForeColor;

            if (fontDialog1.ShowDialog() != DialogResult.Cancel)
            {
                txtBoxTypeString.Font = new Font(fontDialog1.Font.FontFamily, 12, fontDialog1.Font.Style);

                txtBoxTypeString.ForeColor = fontDialog1.Color;

                labelOSDFontColor.BackColor = txtBoxTypeString.ForeColor;
            }            
        }

        private void btnApplyOSDText_Click(object sender, EventArgs e)
        {            
            m_nOsdNum1[m_nChannelNumber] = (uint)comboxOSDLayer1.SelectedIndex;

            m_xoffset1[m_nChannelNumber] = Convert.ToUInt32(txtBox_Xoffset1.Text);

            m_yoffset1[m_nChannelNumber] = Convert.ToUInt32(txtBox_Yoffset1.Text);

            m_width1[m_nChannelNumber] = Convert.ToUInt32(txtBox_width1.Text);

            m_height1[m_nChannelNumber] = Convert.ToUInt32(txtBox_height1.Text);

            m_dwFontColor[m_nChannelNumber] = ColorToUInt(txtBoxTypeString.ForeColor);

            m_dwFontColor[m_nChannelNumber] = m_dwFontColor[m_nChannelNumber] & 0x00FFFFFF;

            uint dwBackgroundColor = 0;

            dwBackgroundColor = ColorToUInt(m_clrFontBackground[m_nChannelNumber]);

            dwBackgroundColor = dwBackgroundColor & 0x00FFFFFF;

            m_dwBackgroundColorTransparent[m_nChannelNumber] = Convert.ToUInt32(comboxBackgroundColorTransparent.SelectedIndex);

            m_dwBackgroundColorTransparent[m_nChannelNumber] = m_dwBackgroundColorTransparent[m_nChannelNumber] << 24;

            dwBackgroundColor = dwBackgroundColor | m_dwBackgroundColorTransparent[m_nChannelNumber];

            m_pszFontFamilyName[m_nChannelNumber] = txtBoxTypeString.Font.FontFamily.Name;

            m_nFontStyle[m_nChannelNumber] = (uint)txtBoxTypeString.Font.Style;
                        
            Font txtFont = txtBoxTypeString.Font;

            bool bBold = txtFont.Bold;

            if (bBold) { m_nFontStyle[m_nChannelNumber] |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_BOLD; }
            
            bool bItalic = txtFont.Italic;

            if (bItalic) { m_nFontStyle[m_nChannelNumber] |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_ITALIC; }
            
            bool bStrikeout = txtFont.Strikeout;

            if (bStrikeout) { m_nFontStyle[m_nChannelNumber] |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_STRIKEOUT; }
            
            bool bUnderline = txtFont.Underline;

            if (bUnderline) { m_nFontStyle[m_nChannelNumber] |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_UNDERLINE; }

            m_nFontSize[m_nChannelNumber] = Convert.ToUInt32(comboxFontSize1.Text);

            m_nTransparent1[m_nChannelNumber] = Convert.ToUInt32(txtBox_Transparent1.Text);

            m_dwFontColorTransparent[m_nChannelNumber] = Convert.ToUInt32(comboxFontColorTransparent.SelectedIndex);

            m_dwFontColorTransparent[m_nChannelNumber] = m_dwFontColorTransparent[m_nChannelNumber] << 24;

            m_dwFontColor[m_nChannelNumber] = m_dwFontColor[m_nChannelNumber] | m_dwFontColorTransparent[m_nChannelNumber];

            m_pszString[m_nChannelNumber] = txtBoxTypeString.Text;

            if (m_hCapDev[m_nChannelNumber] != 0)
            {
                EXPORTS.QCAP_SET_OSD_TEXT(m_hCapDev[m_nChannelNumber], m_nOsdNum1[m_nChannelNumber], (int)m_xoffset1[m_nChannelNumber],

                    (int)m_yoffset1[m_nChannelNumber], (int)m_width1[m_nChannelNumber], (int)m_height1[m_nChannelNumber], ref m_pszString[m_nChannelNumber], ref m_pszFontFamilyName[m_nChannelNumber], m_nFontStyle[m_nChannelNumber],

                    m_nFontSize[m_nChannelNumber], m_dwFontColor[m_nChannelNumber], dwBackgroundColor, m_nTransparent1[m_nChannelNumber]);
            }            
        }

        private void btnBrowsePicPath_Click(object sender, EventArgs e)
        {            
            Stream fileStream;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "D:\\";

            openFileDialog1.Filter = "Image Files (*.bmp;*.png;*.jpg)|*.bmp;*.png;*.jpg|All Files (*.*)|*.*||";

            openFileDialog1.FilterIndex = 0;

            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if ((fileStream = openFileDialog1.OpenFile()) != null)
                {
                    txtBoxPicPath.Text = openFileDialog1.FileName;

                    m_strPicturePath[m_nChannelNumber] = txtBoxPicPath.Text;

                    if (m_PicImage[m_nChannelNumber] != null)
                    {
                        m_PicImage[m_nChannelNumber].Dispose();
                    }

                    picBox.SizeMode = PictureBoxSizeMode.StretchImage;

                    m_PicImage[m_nChannelNumber] = new Bitmap(m_strPicturePath[m_nChannelNumber]);

                    picBox.Image = (Image)m_PicImage[m_nChannelNumber];

                    string strRes = m_PicImage[m_nChannelNumber].Height.ToString() + " x " + m_PicImage[m_nChannelNumber].Height.ToString();

                    txtboxImageRes.Text = strRes;

                    fileStream.Close();
                }
            }            
        }

        private void btnApplyOSDPic_Click(object sender, EventArgs e)
        {            
            m_nOsdNum2[m_nChannelNumber] = (uint)comboxOSDLayer2.SelectedIndex;

            m_xoffset2[m_nChannelNumber] = Convert.ToUInt32(txtBox_Xoffset2.Text);

            m_yoffset2[m_nChannelNumber] = Convert.ToUInt32(txtBox_Yoffset2.Text);

            m_width2[m_nChannelNumber] = Convert.ToUInt32(txtBox_width2.Text);

            m_height2[m_nChannelNumber] = Convert.ToUInt32(txtBox_height2.Text);

            m_nTransparent2[m_nChannelNumber] = Convert.ToUInt32(txtBox_Transparent2.Text);

            if (m_hCapDev[m_nChannelNumber] != 0)
            {
                EXPORTS.QCAP_SET_OSD_PICTURE(m_hCapDev[m_nChannelNumber],  m_nOsdNum2[m_nChannelNumber],  (int)m_xoffset2[m_nChannelNumber],  (int)m_yoffset2[m_nChannelNumber], (int)m_width2[m_nChannelNumber],  (int)m_height2[m_nChannelNumber], ref m_strPicturePath[m_nChannelNumber],  m_nTransparent2[m_nChannelNumber]);
            }            
        }

        private void labelOSDFontColor_Click(object sender, EventArgs e)
        {            
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDFontColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDFontColor.BackColor = ColorDlg.Color;

                m_clrFontForeground[m_nChannelNumber] = ColorDlg.Color;

                txtBoxTypeString.ForeColor = m_clrFontForeground[m_nChannelNumber]; 
            }            
        }

        private void labelOSDBackgroundColor_Click(object sender, EventArgs e)
        {            
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDBackgroundColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDBackgroundColor.BackColor = ColorDlg.Color;

                m_clrFontBackground[m_nChannelNumber] = ColorDlg.Color;

                txtBoxTypeString.BackColor = m_clrFontBackground[m_nChannelNumber];
            }            
        }

        private void comboxFontSize1_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nFontSize[m_nChannelNumber] = Convert.ToUInt32(comboxFontSize1.Text);
        }

        private void comboDownloadScaleMode_SelectedIndexChanged(object sender, EventArgs e)
        {            
            if (comboDownloadScaleMode.SelectedIndex == 0)
            {
                m_DownloadScaleMode[m_nChannelNumber] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF;
            }

            if (comboDownloadScaleMode.SelectedIndex == 1)
            {
                m_DownloadScaleMode[m_nChannelNumber] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_2_3;
            }

            if (comboDownloadScaleMode.SelectedIndex == 2)
            {
                m_DownloadScaleMode[m_nChannelNumber] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_2;
            }

            if (comboDownloadScaleMode.SelectedIndex == 3)
            {
                m_DownloadScaleMode[m_nChannelNumber] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_4;
            }            
        }

        private void MyAdvancedSettingsDlg_Shown(object sender, EventArgs e)
        {          
        }

        protected override void WndProc(ref Message m)
        {            
            if (m.Msg == 0x0018) // WM_SHOWWINDOW
            {
                if (m.WParam == IntPtr.Zero) // THE WINDOW IS BEING HIDDEN
                {
                    if (m_hCloneCapDev[m_nChannelNumber] != 0)
                    {
                        EXPORTS.QCAP_STOP(m_hCloneCapDev[m_nChannelNumber]);

                        EXPORTS.QCAP_DESTROY(m_hCloneCapDev[m_nChannelNumber]); m_hCloneCapDev[m_nChannelNumber] = 0;

                        m_hCloneCapDev[m_nChannelNumber] = 0;

                        return;
                    }
                }
                else // THE WINDOW IS BEING SHOWN
                {
                    if (m_hCloneCapDev[m_nChannelNumber] == 0x00000000 && tabControlAdvancedSettings.SelectedIndex == 4) // OSD PAGE
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[m_nChannelNumber], (uint)panelVideoPreview2.Handle.ToInt32(), ref m_hCloneCapDev[m_nChannelNumber], 1);

                        EXPORTS.QCAP_RUN(m_hCloneCapDev[m_nChannelNumber]);

                        return;
                    }

                    if (m_hCloneCapDev[m_nChannelNumber] == 0x00000000 && tabControlAdvancedSettings.SelectedIndex == 0) // VIDEO INPUT PAGE
                    {
                        uint nInput = (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI;

                        EXPORTS.QCAP_GET_VIDEO_INPUT(m_hCapDev[m_nChannelNumber], ref nInput);

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPOSITE) { RadioButtonCOMPOSITE.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SVIDEO) { RadioButtonSVIDEO.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_HDMI) { RadioButtonInputHDMI.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_D) { RadioButtonInputDVI.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPONENTS) { RadioButtonYCBCR.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_A) { RadioButtonRGB.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI) { RadioButtonSDI.Checked = true; }

                        if (nInput == (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO) { RadioButtonAUTO.Checked = true; }

                        uint nBrightness = 0;

                        EXPORTS.QCAP_GET_VIDEO_BRIGHTNESS(m_hCapDev[m_nChannelNumber], ref nBrightness);

                        m_sliderBrightness.Value = (int)nBrightness;

                        m_staticBrightness.Text = nBrightness.ToString();

                        uint nContrast = 0;

                        EXPORTS.QCAP_GET_VIDEO_CONTRAST(m_hCapDev[m_nChannelNumber], ref nContrast);

                        m_sliderContrast.Value = (int)nContrast;

                        m_staticContrast.Text = nContrast.ToString();

                        uint nHue = 0;

                        EXPORTS.QCAP_GET_VIDEO_HUE(m_hCapDev[m_nChannelNumber], ref nHue);

                        m_sliderHue.Value = (int)nHue;

                        m_staticHue.Text = nHue.ToString();

                        uint nSaturation = 0;

                        EXPORTS.QCAP_GET_VIDEO_SATURATION(m_hCapDev[m_nChannelNumber], ref nSaturation);

                        m_sliderSaturation.Value = (int)nSaturation;

                        m_staticSaturation.Text = nSaturation.ToString();

                        uint nSharpness = 0;

                        EXPORTS.QCAP_GET_VIDEO_SHARPNESS(m_hCapDev[m_nChannelNumber], ref nSharpness);

                        m_sliderSharpness.Value = (int)nSharpness;

                        m_staticSharpness.Text = nSharpness.ToString();

                        nInput = (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

                        EXPORTS.QCAP_GET_AUDIO_INPUT(m_hCapDev[m_nChannelNumber], ref nInput);

                        if (nInput == (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO)
                        {
                            RadioButtonInputEMBEDDEDAUDIO.Checked = true;
                        }

                        if (nInput == (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_LINE_IN)
                        {
                            RadioButtonInputEMBEDDEDLINEIN.Checked = true;
                        }

                        uint nVolume = 0;

                        EXPORTS.QCAP_GET_AUDIO_VOLUME(m_hCapDev[m_nChannelNumber], ref nVolume);

                        trackBarAudioVolume.Value = (int)nVolume;

                        m_staticAudioVolumeB.Text = nVolume.ToString();

                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[m_nChannelNumber], (uint)panelVideoPreview1.Handle.ToInt32(), ref m_hCloneCapDev[m_nChannelNumber], 1);

                        EXPORTS.QCAP_RUN(m_hCloneCapDev[m_nChannelNumber]);

                        return;
                    }
                }
            }          
            
            base.WndProc(ref m);
        }           
    }
}
